/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.energy.tile;

import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.common.Optional;
import ic2.api.energy.tile.IEnergySource;
import java.lang.reflect.Method;
import java.util.EnumSet;
import mekanism.api.energy.ICableOutputter;
import micdoodle8.mods.galacticraft.api.item.ElectricItemHelper;
import micdoodle8.mods.galacticraft.api.item.IItemElectric;
import micdoodle8.mods.galacticraft.api.transmission.grid.IElectricityNetwork;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConductor;
import micdoodle8.mods.galacticraft.api.transmission.tile.IElectrical;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.energy.EnergyConfigHandler;
import micdoodle8.mods.galacticraft.core.energy.EnergyUtil;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseConductor;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectrical;
import micdoodle8.mods.galacticraft.core.util.VersionUtil;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

@Optional.InterfaceList(value={@Optional.Interface(modid="IC2API", iface="ic2.api.energy.tile.IEnergySource"), @Optional.Interface(modid="MekanismAPI|energy", iface="mekanism.api.energy.ICableOutputter")})
public class TileBaseUniversalElectricalSource
extends TileBaseUniversalElectrical
implements IEnergySource,
ICableOutputter {
    public float produce() {
        this.storage.maxExtractRemaining = this.storage.maxExtract;
        float produced = this.extractEnergyGC(null, this.produce(false), false);
        this.storage.maxExtractRemaining -= produced;
        if (this.storage.maxExtractRemaining < 0.0f) {
            this.storage.maxExtractRemaining = 0.0f;
        }
        return produced;
    }

    public float produce(boolean simulate) {
        float amountProduced = 0.0f;
        if (!this.field_145850_b.field_72995_K) {
            EnumSet<ForgeDirection> outputDirections = this.getElectricalOutputDirections();
            outputDirections.remove(ForgeDirection.UNKNOWN);
            BlockVec3 thisVec = new BlockVec3(this);
            for (ForgeDirection direction : outputDirections) {
                float toSend;
                TileEntity tileAdj = thisVec.getTileEntityOnSide(this.field_145850_b, direction);
                if (tileAdj == null || (toSend = this.extractEnergyGC(null, Math.min(this.getEnergyStoredGC() - amountProduced, this.getEnergyStoredGC() / (float)outputDirections.size()), true)) <= 0.0f) continue;
                if (tileAdj instanceof TileBaseConductor) {
                    IElectricityNetwork network = ((IConductor)tileAdj).getNetwork();
                    if (network == null) continue;
                    amountProduced += toSend - network.produce(toSend, !simulate, this.tierGC, this);
                    continue;
                }
                if (tileAdj instanceof TileBaseUniversalElectrical) {
                    amountProduced += ((TileBaseUniversalElectrical)tileAdj).receiveElectricity(direction.getOpposite(), toSend, this.tierGC, !simulate);
                    continue;
                }
                amountProduced += EnergyUtil.otherModsEnergyTransfer(tileAdj, direction.getOpposite(), toSend, simulate);
            }
        }
        return amountProduced;
    }

    public void recharge(ItemStack itemStack) {
        if (itemStack != null) {
            Item item = itemStack.func_77973_b();
            float maxExtractSave = this.storage.getMaxExtract();
            if (this.tierGC > 1) {
                this.storage.setMaxExtract(maxExtractSave * 2.5f);
            }
            float energyToCharge = this.storage.extractEnergyGC(this.storage.getMaxExtract(), true);
            if (item instanceof IItemElectric) {
                this.storage.extractEnergyGC(ElectricItemHelper.chargeItem(itemStack, energyToCharge), false);
            } else if (EnergyConfigHandler.isRFAPILoaded() && item instanceof IEnergyContainerItem) {
                this.storage.extractEnergyGC((float)((IEnergyContainerItem)item).receiveEnergy(itemStack, (int)(energyToCharge * EnergyConfigHandler.TO_RF_RATIO), false) / EnergyConfigHandler.TO_RF_RATIO, false);
            } else if (EnergyConfigHandler.isIndustrialCraft2Loaded()) {
                try {
                    Class<?> itemElectricIC2 = Class.forName("ic2.api.item.ISpecialElectricItem");
                    Class<?> itemElectricIC2B = Class.forName("ic2.api.item.IElectricItem");
                    Class<?> itemManagerIC2 = Class.forName("ic2.api.item.IElectricItemManager");
                    if (itemElectricIC2.isInstance(item)) {
                        double result;
                        Method methodCharge;
                        Object IC2item = itemElectricIC2.cast(item);
                        Method getMan = itemElectricIC2.getMethod("getManager", ItemStack.class);
                        Object IC2manager = getMan.invoke(IC2item, itemStack);
                        if (VersionUtil.mcVersion1_7_2) {
                            methodCharge = itemManagerIC2.getMethod("charge", ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                            result = ((Integer)methodCharge.invoke(IC2manager, itemStack, (int)(energyToCharge * EnergyConfigHandler.TO_IC2_RATIO), this.tierGC + 1, false, false)).intValue();
                        } else {
                            methodCharge = itemManagerIC2.getMethod("charge", ItemStack.class, Double.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                            result = (Double)methodCharge.invoke(IC2manager, itemStack, energyToCharge * EnergyConfigHandler.TO_IC2_RATIO, this.tierGC + 1, false, false);
                        }
                        float energy = (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                        this.storage.extractEnergyGC(energy, false);
                    } else if (itemElectricIC2B.isInstance(item)) {
                        double result;
                        Method methodCharge;
                        Class<?> electricItemIC2 = Class.forName("ic2.api.item.ElectricItem");
                        Object IC2manager = electricItemIC2.getField("manager").get(null);
                        if (VersionUtil.mcVersion1_7_2) {
                            methodCharge = itemManagerIC2.getMethod("charge", ItemStack.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                            result = ((Integer)methodCharge.invoke(IC2manager, itemStack, (int)(energyToCharge * EnergyConfigHandler.TO_IC2_RATIO), this.tierGC + 1, false, false)).intValue();
                        } else {
                            methodCharge = itemManagerIC2.getMethod("charge", ItemStack.class, Double.TYPE, Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
                            result = (Double)methodCharge.invoke(IC2manager, itemStack, energyToCharge * EnergyConfigHandler.TO_IC2_RATIO, this.tierGC + 1, false, false);
                        }
                        float energy = (float)result / EnergyConfigHandler.TO_IC2_RATIO;
                        this.storage.extractEnergyGC(energy, false);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (this.tierGC > 1) {
                this.storage.setMaxExtract(maxExtractSave);
            }
        }
    }

    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        if (receiver instanceof IElectrical || receiver instanceof IConductor) {
            return false;
        }
        try {
            Class<?> energyTile = Class.forName("ic2.api.energy.tile.IEnergyTile");
            if (!energyTile.isInstance(receiver)) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getElectricalOutputDirections().contains(direction);
    }

    public double getOfferedEnergy() {
        if (EnergyConfigHandler.disableIC2Output) {
            return 0.0;
        }
        return this.getProvide(ForgeDirection.UNKNOWN) * EnergyConfigHandler.TO_IC2_RATIO;
    }

    public void drawEnergy(double amount) {
        if (EnergyConfigHandler.disableIC2Output) {
            return;
        }
        this.storage.extractEnergyGC((float)amount / EnergyConfigHandler.TO_IC2_RATIO, false);
    }

    public int getSourceTier() {
        return this.tierGC + 1;
    }

    @Override
    public boolean canOutputTo(ForgeDirection side) {
        return this.getElectricalOutputDirections().contains(side);
    }

    @Override
    public float getProvide(ForgeDirection direction) {
        TileEntity tile;
        if (direction == ForgeDirection.UNKNOWN && EnergyConfigHandler.isIndustrialCraft2Loaded() && (tile = new BlockVec3(this).getTileEntityOnSide(this.field_145850_b, this.getElectricalOutputDirectionMain())) instanceof IConductor) {
            return 0.0f;
        }
        if (this.getElectricalOutputDirections().contains(direction)) {
            return this.storage.extractEnergyGC(Float.MAX_VALUE, true);
        }
        return 0.0f;
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (EnergyConfigHandler.disableRFOutput || !this.getElectricalOutputDirections().contains(from)) {
            return 0;
        }
        return MathHelper.func_76141_d((float)(this.storage.extractEnergyGC((float)maxExtract / EnergyConfigHandler.TO_RF_RATIO, !simulate) * EnergyConfigHandler.TO_RF_RATIO));
    }
}

